﻿-- Creating table 'NB_ExternalChannel'
CREATE TABLE [dbo].[NB_ExternalChannel] (
    [ChannelId] int  NOT NULL,
    [Source] nvarchar(max)  NOT NULL,
    [UpdateInterval] int  NOT NULL,
    [Type] tinyint  NOT NULL,
    [DaysToKeep] int  NOT NULL,
    [ExtendedProperties] nvarchar(max)  NOT NULL
);
GO

-- Creating primary key on [ChannelId] in table 'NB_ExternalChannel'
ALTER TABLE [dbo].[NB_ExternalChannel]
ADD CONSTRAINT [PK_NB_ExternalChannel]
    PRIMARY KEY CLUSTERED ([ChannelId] ASC);
GO

-- Creating foreign key on [ChannelId] in table 'NB_ExternalChannel'
ALTER TABLE [dbo].[NB_ExternalChannel]
ADD CONSTRAINT [FK_NB_ExternalChannelNB_Channel]
    FOREIGN KEY ([ChannelId])
    REFERENCES [dbo].[NB_Channel]
        ([ChannelID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

INSERT INTO [NB_ExternalChannel]
([ChannelId], [Source], [UpdateInterval], [Type])
SELECT [ChannelId], [RssUrl], [UpdateInterval], [Type] = 0
FROM [NB_RssChannel]

IF OBJECT_ID(N'[dbo].[FK_NB_RssChannelNB_Channel]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[NB_RssChannel] DROP CONSTRAINT [FK_NB_RssChannelNB_Channel];
GO

IF OBJECT_ID(N'[dbo].[NB_RssChannel]', 'U') IS NOT NULL
    DROP TABLE [dbo].[NB_RssChannel];
GO

INSERT INTO NB_ContentType([Name], [ExtendedProperties], [Active]) VALUES('Office365Video', '{"plusDays":7,"isVisible":false}', 1)
